//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\SystemUser.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;

/* 
$Header: SystemUser.java, 15, 1/2/01 3:41:00 PM, Schwartz, Joe$
$Log: 
 15   Alkindi Development1.14        1/2/01 3:41:00 PM    Schwartz, Joe  
      Replaced comparable interface, which was missing by accident.
 14   Alkindi Development1.13        12/28/00 1:06:54 PM  Schwartz, Joe   Added
      version control header info.
 13   Alkindi Development1.12        12/26/00 7:21:17 PM  Schwartz, Joe   
 12   Alkindi Development1.11        12/26/00 6:57:25 PM  Schwartz, Joe   
 11   Alkindi Development1.10        12/18/00 12:05:41 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 10   Alkindi Development1.9         12/15/00 6:19:07 PM  Schwartz, Joe   Added
      equals() and hashCode() operations. hashCode() is for hash mapping in
      UserRatingsList.
 9    Alkindi Development1.8         12/1/00 9:48:51 PM   Schwartz, Joe   
 8    Alkindi Development1.7         11/14/00 12:53:16 PM Schwartz, Joe   
 7    Alkindi Development1.6         10/23/00 6:05:33 PM  Schwartz, Joe   Added
      default constructor. Removed member attributes that now appear in
      AccountInfo.
 6    Alkindi Development1.5         10/22/00 2:43:12 PM  Schwartz, Joe   
 5    Alkindi Development1.4         10/22/00 2:43:02 PM  Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 2:35:42 PM  Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:18 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:43 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:14 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A user who rates products and can be clustered. New users are represented as SystemUsers until they create accounts.
 */
public class SystemUser implements Serializable, Comparable 
{
	
	/**
	 * This is an ID internal to the system.
	 */
	public long id;
	
	/**
	 * @roseuid 39ECB86F006D
	 */
	public SystemUser(final long idIn) 
	{
		id = idIn;
	}
	
	/**
	 * @roseuid 39F04A280000
	 */
	public SystemUser() 
	{
		id = 0;
	}
	
	/**
	 * @roseuid 3A28527E03B9
	 */
	public int compareTo(Object srcObj) 
	{
		if (id == ((SystemUser)srcObj).id) 
			return 0;
		return 1;
	}
	
	/**
	 * Provides simple equality testing. Overrides java.lang.Object.equals().
	 * @roseuid 3A3A654F0138
	 */
	public boolean equals(java.lang.Object src) 
	{
		if (src == null)
			return false;
		return (id == ((SystemUser)src).id);
	}
	
	/**
	 * This returns a hash code for the use of Collections interfaces that need one. The hash code is the value of the user id expressed as an integer.
	 * @roseuid 3A3A6E2D036B
	 */
	public int hashCode() 
	{
		return (int)id;
	}
}
